import 'package:dartz/dartz.dart';
import 'package:razinsoft_rider/core/errors/failure.dart';
import 'package:razinsoft_rider/data/models/common_response.dart';
import 'package:razinsoft_rider/data/repositories/base_repository.dart';
import 'package:razinsoft_rider/domain/interfaces/ride_service_interface.dart';

import '../../core/state/rider_service_state.dart';
import '../models/ride_service_response.dart';
import 'interfaces/ride_service_repo_interface.dart';

class RiderServiceRepoImpl extends BaseRepository implements IRideServicesRepo {
  final IRideServicesService _rideServicesService;

  RiderServiceRepoImpl(this._rideServicesService);
  @override
  Future<Either<Failure, RideServiceResponse>> getRideServices({required RiderServiceState riderServiceFilter}) async {
    final data = await safeApiCall(() async {
      final response = await _rideServicesService.getRideServices(riderServiceState: riderServiceFilter);
      return RideServiceResponse.fromJson(response.data);
    });
    data.fold((l) => l, (r) => r);
    return data;
  }

  @override
  Future<Either<Failure, RideServiceResponse>> getServicesHome() async => await safeApiCall(() async {
    final response = await _rideServicesService.getServicesHome();
    return RideServiceResponse.fromJson(response.data);
    });

  @override
  Future<Either<Failure, CommonResponse>> applyCoupon({required String? coupon}) async => safeApiCall(()async{
    final response = await _rideServicesService.applyCoupon(coupon: coupon);
    return CommonResponse.fromMap(response.data);
  });
}
